/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.xacml.client;

import java.net.URL;
import java.rmi.RemoteException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.types.Id;
import org.apache.axis.types.NCName;
import org.apache.axis.types.URI;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.globus.gsi.gssapi.auth.NoAuthorization;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.impl.SecureRandomIdentifierGenerator;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Statement;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.xacml.ctx.ActionType;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.ctx.AttributeValueType;
import org.opensaml.xacml.ctx.DecisionType;
import org.opensaml.xacml.ctx.EnvironmentType;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResourceType;
import org.opensaml.xacml.ctx.ResponseType;
import org.opensaml.xacml.ctx.ResultType;
import org.opensaml.xacml.ctx.StatusCodeType;
import org.opensaml.xacml.ctx.StatusMessageType;
import org.opensaml.xacml.ctx.StatusType;
import org.opensaml.xacml.ctx.SubjectType;
import org.opensaml.xacml.ctx.impl.ActionTypeImplBuilder;
import org.opensaml.xacml.ctx.impl.AttributeTypeImplBuilder;
import org.opensaml.xacml.ctx.impl.AttributeValueTypeImplBuilder;
import org.opensaml.xacml.ctx.impl.DecisionTypeImplBuilder;
import org.opensaml.xacml.ctx.impl.EnvironmentTypeImplBuilder;
import org.opensaml.xacml.ctx.impl.RequestTypeImplBuilder;
import org.opensaml.xacml.ctx.impl.ResourceTypeImplBuilder;
import org.opensaml.xacml.ctx.impl.ResponseTypeImplBuilder;
import org.opensaml.xacml.ctx.impl.ResultTypeImplBuilder;
import org.opensaml.xacml.ctx.impl.StatusCodeTypeImplBuilder;
import org.opensaml.xacml.ctx.impl.StatusMessageTypeImplBuilder;
import org.opensaml.xacml.ctx.impl.StatusTypeImplBuilder;
import org.opensaml.xacml.ctx.impl.SubjectTypeImplBuilder;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionQueryType;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionStatementType;
import org.opensaml.xacml.profile.saml.impl.XACMLAuthzDecisionQueryTypeImplBuilder;
import org.opensaml.xacml.profile.saml.impl.XACMLAuthzDecisionStatementTypeImplBuilder;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.schema.XSBooleanValue;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSStringBuilder;
import org.opensaml.xml.util.XMLHelper;
import org.opensciencegrid.authz.xacml.common.FQAN;
import org.opensciencegrid.authz.xacml.common.OSGSAMLBootstrap;
import org.opensciencegrid.authz.xacml.stubs.Response;
import org.opensciencegrid.authz.xacml.stubs.XACMLAuthorizationPortType;
import org.opensciencegrid.authz.xacml.stubs.XACMLAuthorizationPortTypeSOAPBindingStub;
import org.opensciencegrid.authz.xacml.stubs.XACMLAuthorizationServiceLocator;
import org.opensciencegrid.authz.xacml.stubs.XACMLAuthzDecisionQuery;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XACMLClient {
    public static Log logger = LogFactory.getLog((String)XACMLClient.class.getName());
    public static final PrefixedQName assnname = new PrefixedQName(new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion"));
    protected String X509Subject;
    protected String CondorCanonicalNameID;
    protected String X509SubjectIssuer;
    protected String VO;
    protected String VOMSSigningSubject;
    protected String VOMSSigningIssuer;
    protected String fqan;
    protected String CertificateSerialNumber;
    protected String CASerialNumber;
    protected String VOMS_DNS_Port;
    protected String CertificatePoliciesOIDs;
    protected String CertificateChain;
    protected String resourceType;
    protected String resourceDNSHostName;
    protected String resourceX509ID;
    protected String resourceX509Issuer;
    protected String requestedaction;
    protected String RSL_string;
    static XMLObjectBuilderFactory builderFactory;

    Response authorize(String string) throws RemoteException {
        String string2 = null;
        SubjectType subjectType = this.getSubjectType(string2);
        ResourceType resourceType = this.getResourceType(string2);
        ActionType actionType = this.getActionType(string2);
        EnvironmentType environmentType = XACMLClient.getEnvironmentType();
        return this.authorize(string);
    }

    Response authorize(SubjectType subjectType, ResourceType resourceType, ActionType actionType, EnvironmentType environmentType, String string) throws RemoteException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        String string2 = null;
        XACMLAuthzDecisionQueryType xACMLAuthzDecisionQueryType = null;
        try {
            xACMLAuthzDecisionQueryType = XACMLClient.getQuery(subjectType, resourceType, actionType, environmentType, bl, bl2, bl3, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        logger.trace((Object)("XACML Authz Query is " + xACMLAuthzDecisionQueryType));
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.debug((Object)("Invoke query on authz service " + string));
        XACMLAuthorizationServiceLocator xACMLAuthorizationServiceLocator = new XACMLAuthorizationServiceLocator();
        XACMLAuthorizationPortType xACMLAuthorizationPortType = null;
        try {
            xACMLAuthorizationPortType = xACMLAuthorizationServiceLocator.getXACMLAuthorizationPortTypePort(uRL);
            if (xACMLAuthorizationPortType instanceof XACMLAuthorizationPortTypeSOAPBindingStub) {
                ((XACMLAuthorizationPortTypeSOAPBindingStub)xACMLAuthorizationPortType).setTimeout(30000);
            }
            object = (Stub)xACMLAuthorizationPortType;
            object._setProperty("org.globus.security.authorization", (Object)NoAuthorization.getInstance());
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        logger.debug((Object)"XACMLAuthorizationPort received");
        object = null;
        try {
            object = XACMLClient.convertQuery(xACMLAuthzDecisionQueryType);
        }
        catch (MarshallingException marshallingException) {
        }
        catch (URI.MalformedURIException malformedURIException) {
            // empty catch block
        }
        Response response = null;
        try {
            response = xACMLAuthorizationPortType.authorize((XACMLAuthzDecisionQuery)object);
        }
        catch (RemoteException remoteException) {
            XACMLAuthzDecisionStatementType xACMLAuthzDecisionStatementType = this.getIndeterminateDecision();
            this.setXACMLStatementResponse(xACMLAuthzDecisionStatementType, xACMLAuthzDecisionQueryType);
            this.setXACMLStatementStatus(xACMLAuthzDecisionStatementType, "urn:oasis:names:tc:xacml:1.0:status:processing-error", remoteException.getMessage());
            try {
                response = this.convertToAuthz(xACMLAuthzDecisionStatementType);
            }
            catch (SAMLException sAMLException) {
                throw remoteException;
            }
        }
        return response;
    }

    static void addAttribs(List list, String string, Map<String, String> map) {
        Set<String> set = map.keySet();
        for (String string2 : set) {
            AttributeType attributeType = XACMLClient.getAttributeType(string, string2, map.get(string2));
            list.add(attributeType);
        }
    }

    static AttributeType getAttributeType(String string, String string2, String string3) {
        AttributeValueTypeImplBuilder attributeValueTypeImplBuilder = (AttributeValueTypeImplBuilder)builderFactory.getBuilder(AttributeValueType.DEFAULT_ELEMENT_NAME);
        AttributeTypeImplBuilder attributeTypeImplBuilder = (AttributeTypeImplBuilder)builderFactory.getBuilder(AttributeType.DEFAULT_ELEMENT_NAME);
        AttributeValueType attributeValueType = attributeValueTypeImplBuilder.buildObject();
        attributeValueType.setValue(string3);
        AttributeType attributeType = attributeTypeImplBuilder.buildObject("urn:oasis:names:tc:xacml:2.0:context:schema:os", "Attribute", "xacml-context");
        attributeType.setAttributeID(string2);
        attributeType.setIssuer(string);
        attributeType.setDataType("http://www.w3.org/2001/XMLSchema#string");
        attributeType.getAttributeValues().add(attributeValueType);
        return attributeType;
    }

    private static XACMLAuthzDecisionQuery convertQuery(XACMLAuthzDecisionQueryType xACMLAuthzDecisionQueryType) throws MarshallingException, URI.MalformedURIException {
        Object object;
        MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
        Marshaller marshaller = marshallerFactory.getMarshaller(XACMLAuthzDecisionQueryType.TYPE_NAME_XACML20);
        Element element = marshaller.marshall((XMLObject)xACMLAuthzDecisionQueryType);
        logger.trace((Object)("The XACML element string:\n" + XMLUtils.ElementToString((Element)element)));
        NodeList nodeList = element.getChildNodes();
        ArrayList<MessageElement> arrayList = new ArrayList<MessageElement>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object = nodeList.item(i);
            if (!(object instanceof Element)) continue;
            arrayList.add(new MessageElement((Element)object));
        }
        XACMLAuthzDecisionQuery xACMLAuthzDecisionQuery = new XACMLAuthzDecisionQuery();
        xACMLAuthzDecisionQuery.set_any(arrayList.toArray(new MessageElement[arrayList.size()]));
        if (xACMLAuthzDecisionQueryType.getCombinePoliciesXSBooleanValue() != null) {
            xACMLAuthzDecisionQuery.setCombinePolicies(xACMLAuthzDecisionQueryType.getCombinePoliciesXSBooleanValue().getValue());
        }
        if (xACMLAuthzDecisionQueryType.getConsent() != null && !xACMLAuthzDecisionQueryType.getConsent().trim().equals("")) {
            xACMLAuthzDecisionQuery.setConsent(new URI(xACMLAuthzDecisionQueryType.getConsent()));
        }
        if (xACMLAuthzDecisionQueryType.getDestination() != null && !xACMLAuthzDecisionQueryType.getDestination().trim().equals("")) {
            xACMLAuthzDecisionQuery.setDestination(new URI(xACMLAuthzDecisionQueryType.getDestination()));
        }
        xACMLAuthzDecisionQuery.setID(new Id(xACMLAuthzDecisionQueryType.getID()));
        if (xACMLAuthzDecisionQueryType.getInputContextOnlyXSBooleanValue() != null) {
            xACMLAuthzDecisionQuery.setInputContextOnly(xACMLAuthzDecisionQueryType.getInputContextOnlyXSBooleanValue().getValue());
        }
        if (xACMLAuthzDecisionQueryType.getIssueInstant() != null) {
            object = xACMLAuthzDecisionQueryType.getIssueInstant().toCalendar(Locale.getDefault());
            xACMLAuthzDecisionQuery.setIssueInstant((Calendar)object);
        }
        if (xACMLAuthzDecisionQueryType.getReturnContextXSBooleanValue() != null) {
            xACMLAuthzDecisionQuery.setReturnContext(xACMLAuthzDecisionQueryType.getReturnContextXSBooleanValue().getValue());
        }
        if (xACMLAuthzDecisionQueryType.getVersion() != null) {
            xACMLAuthzDecisionQuery.setVersion(xACMLAuthzDecisionQueryType.getVersion().toString());
        }
        return xACMLAuthzDecisionQuery;
    }

    public static AttributeValueType getStringAttributeValue(String string) {
        AttributeValueTypeImplBuilder attributeValueTypeImplBuilder = (AttributeValueTypeImplBuilder)builderFactory.getBuilder(AttributeValueType.DEFAULT_ELEMENT_NAME);
        AttributeValueType attributeValueType = attributeValueTypeImplBuilder.buildObject();
        attributeValueType.setValue(string);
        return attributeValueType;
    }

    public static AttributeType getAttributeType(String string, String string2, String string3, Vector<AttributeValueType> vector) {
        AttributeTypeImplBuilder attributeTypeImplBuilder = (AttributeTypeImplBuilder)builderFactory.getBuilder(AttributeType.DEFAULT_ELEMENT_NAME);
        AttributeType attributeType = attributeTypeImplBuilder.buildObject("urn:oasis:names:tc:xacml:2.0:context:schema:os", "Attribute", "xacml-context");
        attributeType.setAttributeID(string);
        attributeType.setIssuer(string2);
        attributeType.setDataType(string3);
        attributeType.getAttributeValues().addAll(vector);
        return attributeType;
    }

    public static SubjectType getSubjectType() {
        SubjectTypeImplBuilder subjectTypeImplBuilder = (SubjectTypeImplBuilder)builderFactory.getBuilder(SubjectType.DEFAULT_ELEMENT_NAME);
        return subjectTypeImplBuilder.buildObject();
    }

    public static SubjectType getSubjectType(Map map, String string) {
        logger.debug((Object)"Adding subject attributes");
        SubjectType subjectType = XACMLClient.getSubjectType();
        List list = subjectType.getAttributes();
        XACMLClient.addAttribs(list, string, map);
        return subjectType;
    }

    public SubjectType getSubjectType(String string) {
        String string2;
        String string3;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (this.X509Subject != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/subject/subject-x509-id", this.X509Subject);
        }
        if (this.CondorCanonicalNameID != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/subject/subject-condor-canonical-name-id", this.CondorCanonicalNameID);
        }
        if (this.X509SubjectIssuer != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/subject/subject-x509-issuer", this.X509SubjectIssuer);
        }
        if (this.VO != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/subject/vo", this.VO);
        }
        if (this.VOMSSigningSubject != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/subject/voms-signing-subject", this.VOMSSigningSubject);
        }
        if (this.VOMSSigningIssuer != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/subject/voms-signing-issuer", this.VOMSSigningIssuer);
        }
        if (this.fqan != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/subject/voms-primary-fqan", this.fqan);
        }
        if (this.fqan != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/subject/voms-fqan", this.fqan);
        }
        if (this.CertificateSerialNumber != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/subject/certificate-serial-number", this.CertificateSerialNumber);
        }
        if (this.CASerialNumber != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/subject/ca-serial-number", this.CASerialNumber);
        }
        if (this.VOMS_DNS_Port != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/subject/voms-dns-port", this.VOMS_DNS_Port);
        }
        if (this.CertificatePoliciesOIDs != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/subject/ca-policy-oid", this.CertificatePoliciesOIDs);
        }
        if (this.CertificateChain != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/subject/cert-chain", this.CertificateChain);
        }
        SubjectType subjectType = XACMLClient.getSubjectType(linkedHashMap, string);
        List list = subjectType.getAttributes();
        Stack<String> stack = new Stack<String>();
        if (this.fqan != null) {
            string3 = new FQAN(this.fqan).getGroup();
            string2 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + "/" + stringTokenizer.nextToken();
                stack.add(string2);
            }
        }
        while (!stack.empty()) {
            string3 = (String)stack.pop();
            string2 = XACMLClient.getAttributeType(string, "http://authz-interop.org/xacml/subject/voms-fqan", string3 + "/Role=NULL/Capability=NULL");
            list.add(string2);
        }
        return subjectType;
    }

    public static ResourceType getResourceType(Map map, String string) {
        logger.debug((Object)"Adding resource attributes");
        ResourceTypeImplBuilder resourceTypeImplBuilder = (ResourceTypeImplBuilder)builderFactory.getBuilder(ResourceType.DEFAULT_ELEMENT_NAME);
        ResourceType resourceType = resourceTypeImplBuilder.buildObject();
        List list = resourceType.getAttributes();
        XACMLClient.addAttribs(list, string, map);
        return resourceType;
    }

    public ResourceType getResourceType(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (this.resourceType != null) {
            linkedHashMap.put("urn:oasis:names:tc:xacml:1.0:resource:resource-id", this.resourceType);
        }
        if (this.resourceDNSHostName != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/resource/dns-host-name", this.resourceDNSHostName);
        }
        if (this.resourceX509ID != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/resource/resource-x509-id", this.resourceX509ID);
        }
        if (this.resourceType != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/resource/resource-x509-issuer", this.resourceX509Issuer);
        }
        return XACMLClient.getResourceType(linkedHashMap, string);
    }

    public static ActionType getActionType() {
        return ((ActionTypeImplBuilder)builderFactory.getBuilder(ActionType.DEFAULT_ELEMENT_NAME)).buildObject();
    }

    public static ActionType getActionType(Map map, String string) {
        logger.debug((Object)"Adding action attributes");
        ActionType actionType = XACMLClient.getActionType();
        List list = actionType.getAttributes();
        XACMLClient.addAttribs(list, string, map);
        return actionType;
    }

    public ActionType getActionType(String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (this.requestedaction != null) {
            linkedHashMap.put("urn:oasis:names:tc:xacml:1.0:action:action-id", this.requestedaction);
        }
        if (this.RSL_string != null) {
            linkedHashMap.put("http://authz-interop.org/xacml/action/rsl-string", this.RSL_string);
        }
        return XACMLClient.getActionType(linkedHashMap, string);
    }

    public static EnvironmentType getEnvironmentType() {
        EnvironmentTypeImplBuilder environmentTypeImplBuilder = (EnvironmentTypeImplBuilder)builderFactory.getBuilder(EnvironmentType.DEFAULT_ELEMENT_NAME);
        return environmentTypeImplBuilder.buildObject();
    }

    public static EnvironmentType getEnvironmentType(Map map, String string) {
        logger.debug((Object)"Adding environment attributes");
        EnvironmentType environmentType = XACMLClient.getEnvironmentType();
        List list = environmentType.getAttributes();
        XACMLClient.addAttribs(list, string, map);
        return environmentType;
    }

    public static EnvironmentType getEnvironmentType(Vector<String> vector, String string) {
        logger.debug((Object)"Adding environment attributes");
        EnvironmentType environmentType = XACMLClient.getEnvironmentType();
        if (vector == null || vector.size() < 1) {
            logger.warn((Object)"Obligation ids are null or empty");
            return environmentType;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Vector<AttributeValueType> vector2 = new Vector<AttributeValueType>(1);
            vector2.add(XACMLClient.getStringAttributeValue(vector.get(i)));
            AttributeType attributeType = XACMLClient.getAttributeType("http://authz-interop.org/xacml/environment/pep-oblig-supported", string, "http://www.w3.org/2001/XMLSchema#string", vector2);
            environmentType.getAttributes().add(attributeType);
        }
        return environmentType;
    }

    public static RequestType getRequest(SubjectType subjectType, ResourceType resourceType, ActionType actionType, EnvironmentType environmentType) {
        RequestTypeImplBuilder requestTypeImplBuilder = (RequestTypeImplBuilder)builderFactory.getBuilder(RequestType.DEFAULT_ELEMENT_NAME);
        RequestType requestType = requestTypeImplBuilder.buildObject();
        requestType.getSubjects().add(subjectType);
        requestType.getResources().add(resourceType);
        requestType.setAction(actionType);
        requestType.setEnvironment(environmentType);
        return requestType;
    }

    public static XACMLAuthzDecisionQueryType getQuery(SubjectType subjectType, ResourceType resourceType, ActionType actionType, EnvironmentType environmentType, boolean bl, boolean bl2, boolean bl3, String string) throws NoSuchAlgorithmException {
        XMLObjectBuilderFactory xMLObjectBuilderFactory = Configuration.getBuilderFactory();
        XACMLAuthzDecisionQueryTypeImplBuilder xACMLAuthzDecisionQueryTypeImplBuilder = (XACMLAuthzDecisionQueryTypeImplBuilder)xMLObjectBuilderFactory.getBuilder(XACMLAuthzDecisionQueryType.DEFAULT_ELEMENT_NAME_XACML20);
        XACMLAuthzDecisionQueryType xACMLAuthzDecisionQueryType = xACMLAuthzDecisionQueryTypeImplBuilder.buildObject("urn:oasis:names:tc:xacml:2.0:profile:saml2.0:v2:schema:protocol", "XACMLAuthzDecisionQuery", "xacml-samlp");
        XSBooleanValue xSBooleanValue = new XSBooleanValue();
        xSBooleanValue.setValue(Boolean.valueOf(bl));
        xACMLAuthzDecisionQueryType.setInputContextOnly(xSBooleanValue);
        XSBooleanValue xSBooleanValue2 = new XSBooleanValue();
        xSBooleanValue2.setValue(Boolean.valueOf(bl2));
        xACMLAuthzDecisionQueryType.setInputContextOnly(xSBooleanValue2);
        XSBooleanValue xSBooleanValue3 = new XSBooleanValue();
        xSBooleanValue3.setValue(Boolean.valueOf(bl3));
        xACMLAuthzDecisionQueryType.setCombinePolicies(xSBooleanValue3);
        RequestType requestType = XACMLClient.getRequest(subjectType, resourceType, actionType, environmentType);
        IssuerBuilder issuerBuilder = (IssuerBuilder)xMLObjectBuilderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = issuerBuilder.buildObject();
        issuer.setValue(string);
        SecureRandomIdentifierGenerator secureRandomIdentifierGenerator = new SecureRandomIdentifierGenerator();
        xACMLAuthzDecisionQueryType.setID(secureRandomIdentifierGenerator.generateIdentifier());
        xACMLAuthzDecisionQueryType.setIssuer(issuer);
        xACMLAuthzDecisionQueryType.setVersion(SAMLVersion.VERSION_20);
        xACMLAuthzDecisionQueryType.setRequest(requestType);
        return xACMLAuthzDecisionQueryType;
    }

    XACMLAuthzDecisionStatementType getIndeterminateDecision() {
        XACMLAuthzDecisionStatementType xACMLAuthzDecisionStatementType = null;
        DecisionTypeImplBuilder decisionTypeImplBuilder = (DecisionTypeImplBuilder)builderFactory.getBuilder(DecisionType.DEFAULT_ELEMENT_NAME);
        DecisionType decisionType = decisionTypeImplBuilder.buildObject();
        decisionType.setDecision(DecisionType.DECISION.Indeterminate);
        XACMLAuthzDecisionStatementTypeImplBuilder xACMLAuthzDecisionStatementTypeImplBuilder = (XACMLAuthzDecisionStatementTypeImplBuilder)builderFactory.getBuilder(XACMLAuthzDecisionStatementType.TYPE_NAME_XACML20);
        xACMLAuthzDecisionStatementType = (XACMLAuthzDecisionStatementType)xACMLAuthzDecisionStatementTypeImplBuilder.buildObject(Statement.DEFAULT_ELEMENT_NAME, XACMLAuthzDecisionStatementType.TYPE_NAME_XACML20);
        ResponseTypeImplBuilder responseTypeImplBuilder = (ResponseTypeImplBuilder)builderFactory.getBuilder(ResponseType.DEFAULT_ELEMENT_NAME);
        ResponseType responseType = responseTypeImplBuilder.buildObject();
        ResultTypeImplBuilder resultTypeImplBuilder = (ResultTypeImplBuilder)builderFactory.getBuilder(ResultType.DEFAULT_ELEMENT_NAME);
        ResultType resultType = resultTypeImplBuilder.buildObject();
        resultType.setDecision(decisionType);
        responseType.setResult(resultType);
        xACMLAuthzDecisionStatementType.setResponse(responseType);
        return xACMLAuthzDecisionStatementType;
    }

    void setXACMLStatementResponse(XACMLAuthzDecisionStatementType xACMLAuthzDecisionStatementType, XACMLAuthzDecisionQueryType xACMLAuthzDecisionQueryType) {
        if (xACMLAuthzDecisionQueryType != null) {
            RequestType requestType = xACMLAuthzDecisionQueryType.getRequest();
            if (xACMLAuthzDecisionQueryType.getReturnContextXSBooleanValue() != null && xACMLAuthzDecisionQueryType.getReturnContextXSBooleanValue().getValue().booleanValue()) {
                logger.debug((Object)"Adding query request");
                requestType.releaseDOM();
                requestType.detach();
                xACMLAuthzDecisionStatementType.setRequest(requestType);
            }
        }
    }

    void setXACMLStatementStatus(XACMLAuthzDecisionStatementType xACMLAuthzDecisionStatementType, String string, String string2) {
        StatusTypeImplBuilder statusTypeImplBuilder = (StatusTypeImplBuilder)builderFactory.getBuilder(StatusType.DEFAULT_ELEMENT_NAME);
        StatusType statusType = statusTypeImplBuilder.buildObject();
        StatusCodeTypeImplBuilder statusCodeTypeImplBuilder = (StatusCodeTypeImplBuilder)builderFactory.getBuilder(StatusCodeType.DEFAULT_ELEMENT_NAME);
        StatusCodeType statusCodeType = statusCodeTypeImplBuilder.buildObject();
        StatusMessageTypeImplBuilder statusMessageTypeImplBuilder = new StatusMessageTypeImplBuilder();
        StatusMessageType statusMessageType = statusMessageTypeImplBuilder.buildObject("urn:oasis:names:tc:xacml:2.0:context:schema:os", "StatusMessage", "xacml-context");
        XSStringBuilder xSStringBuilder = (XSStringBuilder)builderFactory.getBuilder(XSString.TYPE_NAME);
        XSString xSString = (XSString)xSStringBuilder.buildObject(XSString.TYPE_NAME);
        statusCodeType.setValue(string);
        statusType.setStatusCode(statusCodeType);
        statusMessageType.setValue(string2);
        statusType.setStatusMessage(statusMessageType);
        xACMLAuthzDecisionStatementType.getResponse().getResult().setStatus(statusType);
    }

    public Response convertToAuthz(XACMLAuthzDecisionStatementType xACMLAuthzDecisionStatementType) throws SAMLException {
        Element element;
        XMLObjectBuilder xMLObjectBuilder = org.opensaml.xml.Configuration.getBuilderFactory().getBuilder(Assertion.DEFAULT_ELEMENT_NAME);
        Assertion assertion = (Assertion)xMLObjectBuilder.buildObject(Assertion.DEFAULT_ELEMENT_NAME);
        assertion.getStatements().add(xACMLAuthzDecisionStatementType);
        XMLObjectBuilder xMLObjectBuilder2 = org.opensaml.xml.Configuration.getBuilderFactory().getBuilder(org.opensaml.saml2.core.Response.DEFAULT_ELEMENT_NAME);
        org.opensaml.saml2.core.Response response = (org.opensaml.saml2.core.Response)xMLObjectBuilder2.buildObject(org.opensaml.saml2.core.Response.DEFAULT_ELEMENT_NAME);
        response.getAssertions().add(assertion);
        MarshallerFactory marshallerFactory = org.opensaml.xml.Configuration.getMarshallerFactory();
        Marshaller marshaller = marshallerFactory.getMarshaller(org.opensaml.saml2.core.Response.DEFAULT_ELEMENT_NAME);
        try {
            element = marshaller.marshall((XMLObject)response);
        }
        catch (MarshallingException marshallingException) {
            logger.error((Object)"marshalling exception", (Throwable)marshallingException);
            throw new SAMLException("Marshalling exception", (Exception)((Object)marshallingException));
        }
        NodeList nodeList = element.getChildNodes();
        ArrayList<MessageElement> arrayList = new ArrayList<MessageElement>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            arrayList.add(new MessageElement((Element)node));
        }
        Response response2 = new Response();
        response2.set_any(arrayList.toArray(new MessageElement[arrayList.size()]));
        try {
            if (response.getConsent() != null && !response.getConsent().equals("")) {
                response2.setConsent(new URI(response.getConsent()));
            }
            if (response.getDestination() != null && !response.getDestination().equals("")) {
                response2.setDestination(new URI(response.getDestination()));
            }
        }
        catch (URI.MalformedURIException malformedURIException) {
            logger.error((Object)malformedURIException);
            throw new SAMLException("Error converting to URI", (Exception)((Object)malformedURIException));
        }
        if (response.getID() != null && !response.getID().equals("")) {
            response2.setID(new Id(response.getID()));
        }
        if (response.getInResponseTo() != null && !response.getInResponseTo().equals("")) {
            response2.setInResponseTo(new NCName(response.getInResponseTo()));
        }
        if (response.getIssueInstant() != null) {
            response2.setIssueInstant(response.getIssueInstant().toCalendar(Locale.getDefault()));
        }
        if (response.getVersion() != null) {
            response2.setVersion(response.getVersion().toString());
        }
        return response2;
    }

    public XACMLAuthzDecisionStatementType convertToXACML(Response response) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Element element = null;
        MessageElement messageElement = null;
        try {
            for (Object object5 : object4 = response.get_any()) {
                object3 = object5.getElementName();
                if (!(object3 instanceof PrefixedQName) || !object3.getLocalName().equals(assnname.getLocalName()) || !object3.getURI().equals(assnname.getURI())) continue;
                messageElement = object5;
                element = messageElement.getAsDOM();
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (element == null) {
            return null;
        }
        object4 = (Element)element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Statement").item(0);
        if (XMLHelper.hasXSIType((Element)object4)) {
            Object object5;
            object2 = object4.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            String string2 = object2.getTextContent().trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
            object5 = null;
            if (stringTokenizer.countTokens() > 1) {
                object5 = stringTokenizer.nextToken();
                object3 = stringTokenizer.nextToken();
            } else {
                object3 = stringTokenizer.nextToken();
            }
            if (object5 != null && (object = object4.lookupNamespaceURI((String)object5)) == null && (string = messageElement.getDeserializationContext().getNamespaceURI((String)object5)) != null) {
                object4.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + (String)object5, string);
            }
        }
        object2 = "XACMLassertion";
        if (object4.hasAttributes()) {
            NamedNodeMap namedNodeMap = object4.getAttributes();
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                object = namedNodeMap.item(i);
                string = object.getPrefix();
                String string3 = object.getNodeValue();
                String string4 = object.getNamespaceURI();
                if (string4 == null || !string4.equals("http://www.w3.org/2000/xmlns/")) continue;
                if (object2 == null && object.getNodeName().equals("xmlns")) {
                    System.out.println(string3);
                    continue;
                }
                if (string == null || !string.equals("xmlns") || !object.getLocalName().equals(object2)) continue;
                System.out.println(string3);
            }
        }
        Element element2 = (Element)object4.getElementsByTagNameNS("urn:oasis:names:tc:xacml:2.0:context:schema:os", "Response").item(0);
        UnmarshallerFactory unmarshallerFactory = org.opensaml.xml.Configuration.getUnmarshallerFactory();
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(XACMLAuthzDecisionStatementType.DEFAULT_ELEMENT_NAME_XACML20);
        object = null;
        try {
            object = (XACMLAuthzDecisionStatementType)unmarshaller.unmarshall((Element)object4);
        }
        catch (UnmarshallingException unmarshallingException) {
            // empty catch block
        }
        return object;
    }

    public String getX509Subject() {
        return this.X509Subject;
    }

    public void setX509Subject(String string) {
        this.X509Subject = string;
    }

    public String getCondorCanonicalNameID() {
        return this.CondorCanonicalNameID;
    }

    public void setCondorCanonicalNameID(String string) {
        this.CondorCanonicalNameID = string;
    }

    public String getX509SubjectIssuer() {
        return this.X509SubjectIssuer;
    }

    public void setX509SubjectIssuer(String string) {
        this.X509SubjectIssuer = string;
    }

    public String getVO() {
        return this.VO;
    }

    public void setVO(String string) {
        this.VO = string;
    }

    public String getVOMSSigningSubject() {
        return this.VOMSSigningSubject;
    }

    public void setVOMSSigningSubject(String string) {
        this.VOMSSigningSubject = string;
    }

    public String getVOMSSigningIssuer() {
        return this.VOMSSigningIssuer;
    }

    public void setVOMSSigningIssuer(String string) {
        this.VOMSSigningIssuer = string;
    }

    public String getFqan() {
        return this.fqan;
    }

    public void setFqan(String string) {
        this.fqan = string;
    }

    public String getCertificateSerialNumber() {
        return this.CertificateSerialNumber;
    }

    public void setCertificateSerialNumber(String string) {
        this.CertificateSerialNumber = string;
    }

    public String getCASerialNumber() {
        return this.CASerialNumber;
    }

    public void setCASerialNumber(String string) {
        this.CASerialNumber = string;
    }

    public String getVOMS_DNS_Port() {
        return this.VOMS_DNS_Port;
    }

    public void setVOMS_DNS_Port(String string) {
        this.VOMS_DNS_Port = string;
    }

    public String getCertificatePoliciesOIDs() {
        return this.CertificatePoliciesOIDs;
    }

    public void setCertificatePoliciesOIDs(String string) {
        this.CertificatePoliciesOIDs = string;
    }

    public String getCertificateChain() {
        return this.CertificateChain;
    }

    public void setCertificateChain(String string) {
        this.CertificateChain = string;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String string) {
        this.resourceType = string;
    }

    public String getResourceDNSHostName() {
        return this.resourceDNSHostName;
    }

    public void setResourceDNSHostName(String string) {
        this.resourceDNSHostName = string;
    }

    public String getResourceX509ID() {
        return this.resourceX509ID;
    }

    public void setResourceX509ID(String string) {
        this.resourceX509ID = string;
    }

    public String getResourceX509Issuer() {
        return this.resourceX509Issuer;
    }

    public void setResourceX509Issuer(String string) {
        this.resourceX509Issuer = string;
    }

    public String getRequestedaction() {
        return this.requestedaction;
    }

    public void setRequestedaction(String string) {
        this.requestedaction = string;
    }

    public String getRSL_string() {
        return this.RSL_string;
    }

    public void setRSL_string(String string) {
        this.RSL_string = string;
    }

    static {
        try {
            Init.init();
            OSGSAMLBootstrap.bootstrap();
        }
        catch (Exception exception) {
            String string = "xacmlInitFailed";
            logger.error((Object)string, (Throwable)exception);
            throw new RuntimeException(string, exception);
        }
        builderFactory = Configuration.getBuilderFactory();
        System.setProperty("axis.socketSecureFactory", "org.glite.security.trustmanager.axis.AXISSocketFactory");
    }
}

