/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager.tomcat;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Properties;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.jsse.JSSEImplementation;
import org.glite.security.trustmanager.tomcat.TMSSLServerSocketFactory;

public class TMSSLImplementation
extends SSLImplementation {
    private static Log LOGGER = LogFactory.getLog(TMSSLImplementation.class);

    public TMSSLImplementation() throws ClassNotFoundException {
        boolean versionProps = true;
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("TMversion.properties");
        Properties props = new Properties();
        InputStream inU = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("JUversion.properties");
        Properties propsU = new Properties();
        try {
            props.load(in);
            propsU.load(inU);
        }
        catch (Exception e) {
            System.out.println("Trustmanager starting, version properties loading failed." + in + inU);
            versionProps = false;
        }
        if (versionProps) {
            System.out.println("Trustmanager v" + props.getProperty("module.version") + " with util-java v" + props.getProperty("module.version") + " starting.");
        }
        Class.forName("org.glite.security.trustmanager.ContextWrapper");
    }

    public String getImplementationName() {
        return "TM-SSL";
    }

    public ServerSocketFactory getServerSocketFactory() {
        return new TMSSLServerSocketFactory();
    }

    public SSLSupport getSSLSupport(Socket arg0) {
        try {
            JSSEImplementation impl = new JSSEImplementation();
            return impl.getSSLSupport(arg0);
        }
        catch (ClassNotFoundException e) {
            LOGGER.fatal((Object)"Internal server error, JSSEImplementation class creation failed:", (Throwable)e);
            return null;
        }
    }

    public SSLSupport getSSLSupport(SSLSession arg0) {
        try {
            Method method;
            JSSEImplementation impl = new JSSEImplementation();
            try {
                method = impl.getClass().getMethod("getSSLSupport", arg0.getClass());
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            try {
                return (SSLSupport)method.invoke((Object)impl, arg0);
            }
            catch (IllegalArgumentException e) {
                LOGGER.fatal((Object)"Internal server error, JSSEImplementation class creation failed:", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.fatal((Object)"Internal server error, JSSEImplementation class creation failed:", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.fatal((Object)"Internal server error, JSSEImplementation class creation failed:", (Throwable)e);
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            LOGGER.fatal((Object)"Internal server error, JSSEImplementation class creation failed:", (Throwable)e);
            return null;
        }
    }
}

