/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.trustmanager.tomcat;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glite.security.SecurityContext;
import org.glite.security.SecurityInfo;
import org.glite.security.SecurityInfoContainer;
import org.glite.security.util.DNHandler;
import org.glite.security.voms.VOMSValidator;

public class EchoSecurity
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>EchoSecurity</title>");
        out.println("</head>");
        out.println("<body bgcolor=\"white\">");
        out.println("<h1>EchoSecurity</h1>");
        out.println("<p>Hello! This is the EchoSecurity servlet.");
        out.println("<p>This servlet prints out all the security related info available from the client.");
        SecurityContext sc = new SecurityContext();
        SecurityContext.setCurrentContext((SecurityContext)sc);
        try {
            X509Certificate[] cert = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
            sc.setClientCertChain(cert);
            String remote = req.getRemoteAddr();
            sc.setRemoteAddr(remote);
            req.getAttribute("javax.servlet.request.key_size");
            String sslId = (String)req.getAttribute("javax.servlet.request.ssl_session");
            sc.setSessionId(sslId);
            SecurityInfo secInfo = SecurityInfoContainer.getSecurityInfo();
            out.println("<p>You're connecting from: " + secInfo.getRemoteAddr() + "\n");
            out.println("<p>The session ID for this connection is: " + secInfo.getSessionId() + "\n");
            out.println("<p>Your DN is: " + secInfo.getClientName() + "\n");
            out.println("<p>Issued by: " + secInfo.getIssuerName() + "\n");
            out.println("<p>Your final certificate subject is: " + DNHandler.getSubject((X509Certificate)cert[0]) + "\n");
            boolean proxy = false;
            try {
                DNHandler.getSubject((X509Certificate)cert[0]).withoutLastCN(true);
                proxy = true;
            }
            catch (Exception e) {
                proxy = false;
            }
            out.println("<p>Your end cert is: " + (proxy ? "proxy certificate" : "end-user certificate") + "\n");
            Vector attribs = VOMSValidator.parse((X509Certificate[])secInfo.getClientCertChain());
            Iterator attribIter = attribs.iterator();
            if (attribs.isEmpty()) {
                out.println("<p>No valid attributes present! \n");
            }
            int i = 0;
            while (attribIter.hasNext()) {
                out.println("<p>Attribute(" + i++ + "): " + attribIter.next() + "\n");
            }
            out.println("<p>Your cert is: ");
            out.println(secInfo.getClientCert().toString());
        }
        catch (Exception e) {
            out.println("<p>Error while handling the certificate chain:");
            e.printStackTrace(out);
        }
        out.println("\n<p>Finished");
        out.println("</body>");
        out.println("</html>");
        out.close();
    }
}

